from Tkinter import *
import os

class HelpDialog:
	def __init__(self, helpMaster="helpBox", helpfile=""):
		self.helpMaster=helpMaster
		self.helpMaster=Toplevel()
		self.helpMaster.withdraw()
		self.helpMaster.protocol('WM_DELETE_WINDOW', lambda:0)
		self.scrollbar = Scrollbar(self.helpMaster, orient=VERTICAL)
		self.helpText=Listbox(self.helpMaster, relief=SUNKEN, width=72, height=15, takefocus=0, yscrollcommand=self.scrollbar.set)
		self.scrollbar.config(command=self.helpText.yview)
		self.closeButton=Button(self.helpMaster, text="Close >>>", width=10, command=self.helpMaster.destroy)
		self.closeButton.pack(side=BOTTOM)
		self.scrollbar.pack(side=RIGHT, fill=Y)
		self.helpText.pack(side=LEFT, fill=BOTH, expand=1)
		openedHelpFile=open(helpfile, "r")
		helptext=openedHelpFile.readlines()
		for x in helptext:
			self.helpText.insert(END, x.strip())
		openedHelpFile.close()
		self.helpMaster.title("Help - [%s]" % os.path.split(helpfile)[1])
		self.helpText.bind("<Button-1>", self.noSelection)
		self.helpText.bind("<B1-Motion>", self.noSelection)
		self.helpText.bind("<ButtonRelease-1>", self.noSelection)
		self.helpMaster.update_idletasks()
		self.helpMaster.geometry("%dx%d+%d+%d" % (self.helpMaster.winfo_reqwidth(), self.helpMaster.winfo_reqheight(), (self.helpMaster.winfo_screenwidth()/2)-(self.helpMaster.winfo_reqwidth()/2)-95, (self.helpMaster.winfo_screenheight()/2)-(self.helpMaster.winfo_reqheight()/2)-40))
		self.helpMaster.deiconify()
		self.helpMaster.focus_set()
		self.closeButton.focus_set()
		self.helpMaster.grab_set()
		self.helpMaster.wait_window()
	
	def noSelection(self, event):
		self.helpText.select_clear(0, END)

if __name__ == '__main__':
	os.chdir("../help")
	root=Tk()
	app=HelpDialog(helpMaster="helpBox", helpfile="MapperGUI_Help.txt")
	root.mainloop()
